<?= $this->extend("templates/hod_base"); ?>

<?= $this->section("content"); ?>
                <?php $page_session = \Config\Services::session(); $pg='vca';?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4>Students</h4>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?= base_url()?>/hod/dashboard">Dashboard</a></li>
              <li class="breadcrumb-item active">Students</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
          <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
              <span class="info-box-icon bg-info elevation-1"><i class="fas fa-users"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">Active</span>
                <span class="info-box-number"><?= $active ?></span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          <!-- /.col -->
          <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box mb-3">
              <span class="info-box-icon bg-success elevation-1"><i class="fas fa-graduation-cap"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">Graduated</span>
                <span class="info-box-number"><?= $graduated ?></span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          <!-- /.col -->

          <!-- fix for small devices only -->
          <div class="clearfix hidden-md-up"></div>

          <div class="col-12 col-sm-6 col-md-3">
              <a href="javascript:void(0)" class="text-dark view_students_by_stat" data-id="Suspended">
            <div class="info-box mb-3">
              <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-exclamation-triangle"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">Suspended</span>
                <span class="info-box-number"><?= $suspended ?></span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
            </a>
          </div>
          <!-- /.col -->
          <div class="col-12 col-sm-6 col-md-3">
              <a href="javascript:void(0)" class="text-dark view_students_by_stat" data-id="Expelled">
            <div class="info-box mb-3">
              <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-ban"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">Expelled</span>
                <span class="info-box-number"><?= $expelled ?></span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
            </a>
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
        <div class="row">
            <div class="col-12">
            <div class="card">
              <div class="card-header">
                <h4 class="card-title"><b>Active Students</b></h4><br/>
                <hr/>
                <div class="row">
                    <div class="col-4">
                        <div class="form-group">
                            <label>Programme:</label>
                            <select name="programme" id="programme" class="form-control select2" required>
                                <option disabled selected>Select Programme</option>
                                <?php foreach($programmes as $prog): ?>
                                <option value="<?= $prog->id ?>"><?= $prog->title ?></option>
                                <?php endforeach; ?>
                            </select>
                      </div>
                    </div>
                    <div class="col-4">
                        <div class="form-group">
                            <label>Level:</label>
                            <select name="level" id="level" class="form-control select2" required>
                                <option disabled selected>Select Level</option>
                                <option value='100'>100</option>
                                <option value='200'>200</option>
                                <option value='300'>300</option>
                                <option value='400'>400</option>
                                <option value='SO1'>SO I</option>
                                <option value='SO2'>SO II</option>
                            </select>
                      </div>
                    </div>
                    <div class="col-4">
                        <div class="form-group">
                            <label>Gender:</label>
                            <select name="gender" id="gender" class="form-control select2" onchange="spawn_students()" required>
                                <option disabled selected>Select Gender</option>
                                <option value='All'>All</option>
                                <option value='M'>Male</option>
                                <option value='F'>Female</option>
                            </select>
                      </div>
                    </div>
                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="row">
                  <div class="col-md-12">
                    <div id="txtHintDeptStudents"><b>List of Students Here...</b></div>
                  </div>
                </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
            </div>
        </div>

        </div><!-- /.container-fluid -->
    </section>
<!-- /.content -->
</div>
 
  <div class="modal fade" id="studentModal">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="overlay" id="overlay">
            <i class="fas fa-2x fa-sync fa-spin"></i>
        </div>
        <div class="modal-header">
            <h6 class="modal-title" id="modal_title"></h6>
            <ul class="nav nav-pills modal-title">
              <li class="nav-item"><a class="nav-link active" href="#biodata" data-toggle="tab">Bio Data</a></li>
              <li class="nav-item"><a class="nav-link" href="#contact" data-toggle="tab">Contact</a></li>
              <li class="nav-item"><a class="nav-link" href="#nok" data-toggle="tab">Next Of Kin</a></li>
              <li class="nav-item"><a class="nav-link" href="#sponsor" data-toggle="tab">Sponsorship</a></li>
            </ul>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div id="data"></div>
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
 
  <div class="modal fade" id="viewModal">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="overlay" id="overlay1">
            <i class="fas fa-2x fa-sync fa-spin"></i>
        </div>
        <div class="modal-header">
            <h6 class="modal-title" id="modal_title1"></h6>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class='row'>
			<div class='col-md-12 table-responsive' > 
			<table id='student_stat_tbl' class='table table-bordered table-striped'>
				<thead>
				    <tr>
    					<th>S/N</th> 
    					<th>Full Name<br/><small>Registration No.</small></th>
    					<th>Gender</th>
    					<th>Programme</th>
    					<th>Admission Year</th>
    					<th>Phone No.</th>
    					<!--<th>Action</th>-->
					</tr>
			   </thead>
    			<tbody id="data1">
    			</tbody>
    		</table>
			</div>
		  </div>
        </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>

<?= $this->endSection(); ?>