<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php'))
{
	require SYSTEMPATH . 'Config/Routes.php';
}

// Maintenance var
$under_maintenance = FALSE;

/**
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

//route under maintenance
if($under_maintenance){
    $routes->get('(:any)', 'Home::maintenance');
}




/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
//$routes->get('/', 'Home::index');
//$routes->get('register/', 'Home::register');
//$routes->get('about/', 'Home::about');
//$routes->match(['get','post'],'contact/', 'Home::contact');
//$routes->get('student/login/', 'Student::login');
//$routes->match(['get','post'],'register_handler/', 'Home::register_handler');
//$routes->get('under_construction/', 'Home::under_construction');
//$routes->add('level-login', 'Levelcoordinator::login');j

//Lecturer Routes
$routes->add('lecturer-login', 'Lecturer::login');
$routes->add('lecturer-logout', 'Lecturer::logout');
$routes->add('lecturer-index', 'Lecturer::dashboard');
$routes->add('lecturer-course-allocations', 'Lecturer::view_course_allocations');
$routes->add('lecturer-view-student-enrollments', 'Lecturer::view_student_enrollments');
$routes->add('lecturer-download-result-sheet', 'Lecturer::download_result_sheet');
$routes->add('lecturer-upload-exam-result', 'Lecturer::upload_exam_result');
$routes->add('lecturer-uploaded-results', 'Lecturer::track_uploaded_results');
$routes->add('lecturer-change-password', 'Lecturer::password');

//LevelCoordinator Routes
$routes->add('lev-login', 'Levelcoordinator::login');
$routes->add('lev-logout', 'Levelcoordinator::logout');
$routes->add('lev-index', 'Levelcoordinator::dashboard');
$routes->add('lev-students', 'Levelcoordinator::view_students');
$routes->add('lev-transfer', 'Levelcoordinator::transfer_students');
$routes->add('lev-registrations', 'Levelcoordinator::course_registrations');
$routes->add('lev-enrollments', 'Levelcoordinator::course_enrollments');
$routes->add('lev-submissions', 'Levelcoordinator::lecturers_submission');
$routes->add('lev-results', 'Levelcoordinator::compute_result');
$routes->add('lev-verify', 'Levelcoordinator::verify_result');
$routes->add('lev-reports', 'Levelcoordinator::session_report');
$routes->add('lev-configurations', 'Levelcoordinator::registration_configurations');
$routes->add('lev-password', 'Levelcoordinator::password');

//Examination Officer Routes
$routes->add('exam-login', 'Examofficer::login');
$routes->add('exam-logout', 'Examofficer::logout');
$routes->add('exam-index', 'Examofficer::dashboard');
$routes->add('exam-submissions', 'Examofficer::lecturers_submission');
$routes->add('exam-password', 'Examofficer::password');

//HOD Routes
$routes->add('head-login', 'Hod::login');
$routes->add('head-logout', 'Hod::logout');
$routes->add('head-index', 'Hod::dashboard');
$routes->add('head-examofficers', 'Hod::examofficers');
$routes->add('head-levelcoordinators', 'Hod::levelcoordinators');
$routes->add('head-staff', 'Hod::view_staffs');
$routes->add('head-students', 'Hod::view_students_page');
$routes->add('head-courses', 'Hod::view_courses');
$routes->add('head-allocate', 'Hod::allocate_course');
$routes->add('head-allocations', 'Hod::course_allocation');
$routes->add('head-submissions', 'Hod::approve_submission');
$routes->add('head-profile', 'Hod::profile');

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
	require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
