<!DOCTYPE html>
<html lang="en">
<head>
<?php $page_session = \Config\Services::session(); ?>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?= base_url("/../assets/img/yumsuk_logo.png");?>" type="image/x-icon">
  <title>GSP Coordinator | <?= $page_title ?> | <?= $page_subtitle ?></title>
<!-- Google Font: Source Sans Pro -->
<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/fontawesome-free/css/all.min.css"); ?>">
  <!-- daterange picker -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/daterangepicker/daterangepicker.css");?>">
  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="<?= base_url("/.../assets_/plugins/icheck-bootstrap/icheck-bootstrap.min.css")?>">
  <!-- Bootstrap Color Picker -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css")?>">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css")?>">
  <!-- Toastr -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/toastr/toastr.min.css")?>">
  <!-- Sweet Alert -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/sweetalert2/sweetalert2.min.css")?>">
  <!-- Select2 -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/select2/css/select2.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css")?>">
  <!-- Bootstrap4 Duallistbox -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css")?>">
  <!-- BS Stepper -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/bs-stepper/css/bs-stepper.min.css")?>">
  <!-- dropzonejs -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/dropzone/min/dropzone.min.css")?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/dist/css/adminlte.min.css")?>">

  <!-- DataTables -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-responsive/css/responsive.bootstrap4.min.css")?>">
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/datatables-buttons/css/buttons.bootstrap4.min.css")?>">

  <!-- iCheck for checkboxes and radio inputs -->
  <link rel="stylesheet" href="<?= base_url("/../assets_/plugins/icheck-bootstrap/icheck-bootstrap.min.css")?>">
</head>
<body class="text-sm hold-transition sidebar-mini" >
<div class="wrapper">
  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="<?= base_url(); ?>/gsp/dashboard" class="nav-link">Home</a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="<?= base_url(); ?>/gsp/logout" class="nav-link">Logout</a>
      </li>
    </ul>

    <!-- Right navbar links -->
   <ul class="navbar-nav ml-auto">

      <li class="nav-item dropdown user-menu">
        <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">
          <img src="<?= base_url("/../assets/img/avatar.png")?>" class="user-image img-circle elevation-2" alt="User Image">
          <span class="d-none d-md-inline"><?= $page_session->get('name'); ?></span>
        </a>
        <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
          <!-- User image -->
          <li class="user-header bg-primary">
            <img src="<?= base_url("/../assets/img/avatar.png")?>" class="img-circle elevation-2" alt="User Image">
            <p>
              <?= $page_session->get('name'); ?>
              <small><?= $page_session->get('email'); ?></small>
            </p>
          </li>
          <!-- Menu Footer-->
          <li class="user-footer">
            <a href="#" class="btn btn-default btn-flat">Profile</a>
            <a href="<?= base_url()?>/gsp/logout" class="btn btn-default btn-flat float-right">logout</a>
          </li>
        </ul>
      </li>
    </ul>
  </nav>
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="#" class="brand-link">
      <img src="<?= base_url("/../assets/img/avatar.png")?>" alt="RPS Logo" class="brand-image img-circle elevation-3" style="opacity: .8">
      <span class="brand-text font-weight-light">YUMSUK RPS</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
      <!-- Sidebar user (optional) -->
      <div class="user-panel mt-3 pb-3 mb-3 d-flex text-center">
        
        <div class="info">
          <a href="#" class="d-block"><?= $page_session->get('name') ?><br/><?= $page_session->get('email') ?></a>
        </div>
      </div>
        <div class="user-panel mb-3 d-flex" style="background-color: #000000;">
          <div class="info">
            <a href="javascript:void(0);"><?php echo "Current Session: ".$page_session->get('current_session'); ?></a>
            <br/>
          </div>
        </div>

      <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
         
		  <li class="nav-item">
            <a href="<?= base_url(); ?>/gsp/dashboard" class="nav-link <?php echo ($page_title=='Dashboard')?'active':'' ?>">
              <i class="nav-icon fas fa-tachometer-alt"></i>
              <p>
                Dashboard
                </p>
            </a>
          </li>
          
          <li class="nav-item <?php echo ($page_title=='Courses')?'menu-open':'' ?>">
            <a href="#" class="nav-link <?php echo ($page_title=='Courses')?'active':'' ?>">
              <i class="nav-icon fas fa-book"></i>
              <p>
              Courses
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?= base_url(); ?>/gsp/view_courses" class="nav-link <?php echo ($page_subtitle=='View Courses')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>View Courses</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?= base_url(); ?>/gsp/view_student_enrollments" class="nav-link <?php echo ($page_subtitle=='Students')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Students Enrollment</p>
                </a>
              </li>
              
            </ul>
          </li>

          <li class="nav-item <?php echo ($page_title=='My Results')?'menu-open':'' ?>">
            <a href="#" class="nav-link <?php echo ($page_title=='My Results')?'active':'' ?>">
              <i class="nav-icon fas fa-chart-bar"></i>
              <p>
              Exam Results
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?= base_url(); ?>/gsp/download_result_template" class="nav-link <?php echo ($page_subtitle=='Download Template')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Download Result Template</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?= base_url(); ?>/gsp/upload_exam_result" class="nav-link <?php echo ($page_subtitle=='Upload Result')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Upload Result Template</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?= base_url(); ?>/gsp/track_uploaded_results" class="nav-link <?php echo ($page_subtitle=='Track Result')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Track Uploaded Result</p>
                </a>
              </li>
              
            </ul>
          </li>
 
          <li class="nav-item <?php echo ($page_title=='Settings')?'menu-open':'' ?>">
            <a href="#" class="nav-link <?php echo ($page_title=='Settings')?'active':'' ?>">
              <i class="nav-icon fas fa-cog"></i>
              <p>
                Settings
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?= base_url(); ?>/gsp/password" class="nav-link <?php echo ($page_subtitle=='Change Password')?'active':'' ?>">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Change Password</p>
                </a>
              </li>
              
            </ul>
          </li>

          <li class="nav-item">
            <a href="<?= base_url(); ?>/gsp/logout" class="nav-link">
              <i class="nav-icon fas fa-sign-out-alt"></i>
              <p>
                Logout
                </p>
            </a>
          </li>
          
        </ul>
      </nav>
      <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
  </aside>

  <?= $this->renderSection("content"); ?>
              
            <!-- /.card -->
          </div>
        </div>
        <!-- /.row -->
        
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <div class="float-right d-none d-sm-block">
        Powered by the Directorate of ICT and Department of Computer Science.
        &nbsp; &nbsp; &nbsp; &nbsp; 
        <b>Version</b> 1.0
    </div>
    Copyright &copy; <?= "2022-".date("Y") ?> <a href="http://www.yumsuk.edu.ng">Yusuf Maitama Sule University, Kano</a>. All rights
    reserved.
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="<?= base_url("/../assets_/plugins/jquery/jquery.min.js");?>"></script>
<!-- Bootstrap 4 -->
<script src="<?= base_url("/../assets_/plugins/bootstrap/js/bootstrap.bundle.min.js");?>"></script>
<!-- Toastr -->
<script src="<?= base_url("/../assets_/plugins/toastr/toastr.min.js")?>"></script>
<!-- Sweet Alert -->
<script src="<?= base_url("/../assets_/plugins/sweetalert2/sweetalert2.min.js")?>"></script>
<!-- Select2 -->
<script src="<?= base_url("/../assets_/plugins/select2/js/select2.full.min.js");?>"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="<?= base_url("/../assets_/plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js");?>"></script>
<!-- InputMask -->
<script src="<?= base_url("/../assets_/plugins/moment/moment.min.js")?>"></script>
<script src="<?= base_url("/../assets_/plugins/inputmask/jquery.inputmask.min.js");?>"></script>
<!-- date-range-picker -->
<script src="<?= base_url("../assets_/plugins/daterangepicker/daterangepicker.js");?>"></script>
<!-- bootstrap color picker -->
<script src="<?= base_url("/../assets_/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js");?>"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="<?= base_url("/../assets_/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js");?>"></script>
<!-- Bootstrap Switch -->
<script src="<?= base_url("/../assets_/plugins/bootstrap-switch/js/bootstrap-switch.min.js");?>"></script>
<!-- BS-Stepper -->
<script src="<?= base_url("/../assets_/plugins/bs-stepper/js/bs-stepper.min.js");?>"></script>
<!-- dropzonejs -->
<script src="<?= base_url("/../assets_/plugins/dropzone/min/dropzone.min.js");?>"></script>
<!-- AdminLTE App -->
<script src="<?= base_url("/../assets_/dist/js/adminlte.min.js");?>"></script>
<!-- AdminLTE for demo purposes -->
<script src="<?= base_url("/../assets_/dist/js/demo.js");?>"></script>
<!-- jquery-validation -->
<script src="<?= base_url("/../assets_/plugins/jquery-validation/jquery.validate.min.js");?>"></script>
<script src="<?= base_url("/../assets_/plugins/jquery-validation/additional-methods.min.js");?>"></script>
<!-- Page specific script -->

<!-- DataTables  & Plugins -->
<script src="<?= base_url("/../assets_/plugins/datatables/jquery.dataTables.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-responsive/js/dataTables.responsive.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/dataTables.buttons.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/jszip/jszip.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/pdfmake/pdfmake.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/pdfmake/vfs_fonts.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.html5.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.print.min.js"); ?>"></script>
<script src="<?= base_url("/../assets_/plugins/datatables-buttons/js/buttons.colVis.min.js"); ?>"></script>

  <!-- Custom scripts for all pages-->
<script src="<?= base_url("/../assets/js/sb-admin-2.min.js"); ?>"></script>

<!-- Toastr -->
<script src="<?= base_url("/../assets/plugins/toastr/toastr.min.js"); ?>"></script>
<script>
   jQuery(document).ready(function() {
    //Initialize Select2 Elements
        $('.select2').select2();

    //Initialize Select2 Elements
    $('.select2bs4').select2({
      theme: 'bootstrap4'
    });
        <?php if($page_subtitle=='View My Courses'){?> 
            spawn_allocations(); 
        <?php } 
         if($page_subtitle=='Students'){?> 
            spawn_allocated_courses_enrollment(); 
        <?php }
         if($page_subtitle=='Track Result'){?> 
            spawn_results_uploaded(); 
        <?php }
         if($page_subtitle=='Download Template'){?> 
            spawn_allocated_courses(); 
        <?php }
         if($page_subtitle=='Upload Result'){?> 
            spawn_allocated_courses_upload(); 
        <?php } ?>
       
   });
  $(function () {

    //Datemask dd/mm/yyyy
    $('#datemask').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' })
    //Datemask2 mm/dd/yyyy
    $('#datemask2').inputmask('mm/dd/yyyy', { 'placeholder': 'mm/dd/yyyy' })
    //Money Euro
    $('[data-mask]').inputmask()

    //Date range picker
    $('#reservationdate').datetimepicker({
        format: 'L'
    });
    //Date range picker
    $('#reservation').daterangepicker()
    //Date range picker with time picker
    $('#reservationtime').daterangepicker({
      timePicker: true,
      timePickerIncrement: 30,
      locale: {
        format: 'MM/DD/YYYY hh:mm A'
      }
    })
    //Date range as a button
    $('#daterange-btn').daterangepicker(
      {
        ranges   : {
          'Today'       : [moment(), moment()],
          'Yesterday'   : [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days' : [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month'  : [moment().startOf('month'), moment().endOf('month')],
          'Last Month'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        startDate: moment().subtract(29, 'days'),
        endDate  : moment()
      },
      function (start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'))
      }
    )

    //Timepicker
    $('#timepicker').datetimepicker({
      format: 'LT'
    })

    //Bootstrap Duallistbox
    $('.duallistbox').bootstrapDualListbox()

    //Colorpicker
    $('.my-colorpicker1').colorpicker()
    //color picker with addon
    $('.my-colorpicker2').colorpicker()

    $('.my-colorpicker2').on('colorpickerChange', function(event) {
      $('.my-colorpicker2 .fa-square').css('color', event.color.toString());
    })

    $("input[data-bootstrap-switch]").each(function(){
      $(this).bootstrapSwitch('state', $(this).prop('checked'));
    })

  })
  // BS-Stepper Init
  document.addEventListener('DOMContentLoaded', function () {
    window.stepper = new Stepper(document.querySelector('.bs-stepper'))
  })

  // DropzoneJS Demo Code Start
  Dropzone.autoDiscover = false

  // Get the template HTML and remove it from the doumenthe template HTML and remove it from the doument
  var previewNode = document.querySelector("#template")
  previewNode.id = ""
  var previewTemplate = previewNode.parentNode.innerHTML
  previewNode.parentNode.removeChild(previewNode)

  var myDropzone = new Dropzone(document.body, { // Make the whole body a dropzone
    url: "/target-url", // Set the url
    thumbnailWidth: 80,
    thumbnailHeight: 80,
    parallelUploads: 20,
    previewTemplate: previewTemplate,
    autoQueue: false, // Make sure the files aren't queued until manually added
    previewsContainer: "#previews", // Define the container to display the previews
    clickable: ".fileinput-button" // Define the element that should be used as click trigger to select files.
  })

  myDropzone.on("addedfile", function(file) {
    // Hookup the start button
    file.previewElement.querySelector(".start").onclick = function() { myDropzone.enqueueFile(file) }
  })

  // Update the total progress bar
  myDropzone.on("totaluploadprogress", function(progress) {
    document.querySelector("#total-progress .progress-bar").style.width = progress + "%"
  })

  myDropzone.on("sending", function(file) {
    // Show the total progress bar when upload starts
    document.querySelector("#total-progress").style.opacity = "1"
    // And disable the start button
    file.previewElement.querySelector(".start").setAttribute("disabled", "disabled")
  })

  // Hide the total progress bar when nothing's uploading anymore
  myDropzone.on("queuecomplete", function(progress) {
    document.querySelector("#total-progress").style.opacity = "0"
  })

  // Setup the buttons for all transfers
  // The "add files" button doesn't need to be setup because the config
  // `clickable` has already been specified.
  document.querySelector("#actions .start").onclick = function() {
    myDropzone.enqueueFiles(myDropzone.getFilesWithStatus(Dropzone.ADDED))
  }
  document.querySelector("#actions .cancel").onclick = function() {
    myDropzone.removeAllFiles(true)
  }
  // DropzoneJS Demo Code End
</script>

<script type="text/javascript">

   $(document).on('click', '.delete_btn', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure you want to delete this result?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('gsp/result_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'delete'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('Deleted!', data.success, 'success');
                setTimeout(function(){
                    location.reload();
                }, 2500);
              }
            }
          })
        }
        return false;
      })
    });

    $(document).on('click', '.submit_btn', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure you want to submit this result?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, submit it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('gsp/result_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'submit'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('Submitted!', data.success, 'success');
                setTimeout(function(){
                    location.reload();
                }, 2500);
              }
            }
          })
        }
        return false;
      })
    });

    $(document).on('click', '.edit_btn', function(){
      var id = $(this).data('id');
      Swal.fire({
        title: "Are you sure you want to perform the following changes?",
        text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, save it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('gsp/result_action') ?>",
            method: "POST",
            dataType: 'JSON',
            data:{id:id, action:'edit'},
            success:function(data){
              if(data.error != ''){
                toastr.error(data.error);
              }else{
                toastr.success(data.success);
                Swal.fire('editted!', data.success, 'success');
                setTimeout(function(){
                    location.reload();
                }, 2500);
              }
            }
          })
        }
        return false;
      })
    });
    
    $(document).on('click', '.submit_button', function(){
      Swal.fire({
        title: "Are you sure?",
        text: "Attendance record could be edited later!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, save it!'
      }).then((result) => {
        if(result.isConfirmed){
          $.ajax({
            url: "<?php echo base_url('gsp/attendance') ?>",
            method: "POST",
            data: $(this).serialize(),
            dataType: 'json',
            beforeSend:function(){
              $('#submit_button1').attr('disabled', 'disabled');
              $('#submit_button1').val('Please wait...');
              $('#submit_button2').attr('disabled', 'disabled');
              $('#submit_button2').val('Please wait...');
            },
            success:function(data){
              $('#submit_button1').attr('disabled', false);
              $('#submit_button2').attr('disabled', false);
              if(data.error != ''){
                toastr.error(data.error);
                $('#submit_button1').val('Save Attendance');
                $('#submit_button2').val('Save Attendance');
              }else{
                toastr.success(data.success);
              }
            }
          })
        }
        return false;
      })
    });

 $(document).ready(function(){
  
      <?php if($page_session->getFlashdata('editSuccess')) { ?>
        toastr.success("<?= $page_session->getFlashdata('editSuccess') ?>");
      <?php } ?>
    
      <?php if($page_session->getFlashdata('editError')) { ?>
        toastr.error("<?= $page_session->getFlashdata('editError') ?>");
      <?php } ?>
    });
    
    $(document).ready(function(){
  
      <?php if($page_session->getFlashdata('uploadSuccess')) { ?>
        toastr.success("<?= $page_session->getFlashdata('uploadSuccess') ?>");
      <?php } ?>
    
      <?php if($page_session->getFlashdata('uploadError')) { ?>
        toastr.error("<?= $page_session->getFlashdata('uploadError') ?>");
      <?php } ?>
    });
</script>

<script>
  $(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    $("#lecturer").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });
</script>

<script>
    function spawn_allocations(){
      $('.select2').select2();
        //var programme = $('#progammes').val();
        var session = document.getElementById('sessionField').value; 
        //alert(session);
           	
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                            document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                                 
                         //stuff for data table     
                         //stuff for data table     
                         $("#example1").DataTable({
                          "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                          "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                        $('#example2').DataTable({
                          "paging": true,
                          "lengthChange": false,
                          "searching": false,
                          "ordering": true,
                          "info": true,
                          "autoWidth": false,
                          "responsive": true,
                        });
         
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('gsp/get_course_allocations') ?>/"+session+"/"+"\"",true);
                     xmlhttp.send();
      }

    </script>

<script>
    function spawn_allocated_courses_enrollment(){
        var session = document.getElementById('sessionField').value;
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('allocatedCourseField').innerHTML = this.responseText
          document.getElementById('allocatedProgrammeField').innerHTML = "";
          document.getElementById('txtHintDeptStudents').innerHTML = "";
        }
      
        xhttp.open("GET","<?= base_url('gsp/get_allocated_courses_enrolled_students/') ?>/"+session+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_allocated_programmes(){
        var course = document.getElementById('courseField').value;
        var session = $('#sessionField').val();
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('allocatedProgrammeField').innerHTML = this.responseText;
          document.getElementById('download_btn').innerHTML = "";
            }
      

        xhttp.open("GET","<?= base_url('gsp/get_allocated_program_enrolled/') ?>/"+course+"/"+session+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_allocated_programmes_enrollment(){
        var course = document.getElementById('courseField').value;
        var session = $('#sessionField').val();
        const xhttp = new XMLHttpRequest();

                 xhttp.onreadystatechange = function() {
                         
                             
        $('.select2').select2();
         
                     };

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
        $('.select2').select2();
          document.getElementById('allocatedProgrammeField').innerHTML = this.responseText;
          
            }
      

        xhttp.open("GET","<?= base_url('gsp/get_allocated_program_enrollment/') ?>/"+course+"/"+session+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_enrollment_list(){
        var programme = document.getElementById('programmesField').value; 
        var course = $('#courseField').val();
        var session = $('#sessionField').val(); 
        //alert(semester);     	
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
        $('.select2').select2();
                             document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                                 
                            //stuff for data table     
                            $("#example1").DataTable({
                            "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                            $('#example2').DataTable({
                              "paging": true,
                              "lengthChange": false,
                              "searching": false,
                              "ordering": true,
                              "info": true,
                              "autoWidth": false,
                              "responsive": true,
                            }); 
         
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('gsp/get_students_enrolled/') ?>/"+session+"/"+course+"/"+programme+"/"+"\"",true);
                     xmlhttp.send();
      }

    </script>

    <script>
        function spawn_allocated_courses(){
            var course = document.getElementById('sessionField').value;
            const xhttp = new XMLHttpRequest();

            xhttp.onload = function() {
              //$('#ward_area').html(this.responseText);
              document.getElementById('allocatedCourseField').innerHTML = this.responseText
              document.getElementById('allocatedProgrammeField').innerHTML = "";
              document.getElementById('download_btn').innerHTML = "";
                }
          

            xhttp.open("GET","<?= base_url('gsp/get_allocated_courses_enrolled/') ?>/"+course+"/"+"\"",true);
            xhttp.send();
        }    
    </script>

    <script>
        function spawn_programmes(){
            var course = document.getElementById('courseField').value;
            const xhttp = new XMLHttpRequest();

            xhttp.onload = function() {
              //$('#ward_area').html(this.responseText);
              document.getElementById('programmeField').innerHTML = this.responseText;
                }
          

            xhttp.open("GET","<?= base_url('gsp/get_program_enrolled/') ?>/"+course+"/"+"\"",true);
            xhttp.send();
        }    
    </script>

    <script>
        function spawn_button(){
            var session = document.getElementById('sessionField').value;
            var course = document.getElementById('courseField').value;
            var programme = document.getElementById('programmesField').value;

            const xhttp = new XMLHttpRequest();

            xhttp.onload = function() {
            document.getElementById('download_btn').innerHTML = this.responseText;        	
            }

            xhttp.open("GET","<?= base_url('gsp/download_button/') ?>/"+session+"/"+course+"/"+programme+"/"+"\"",true);
            xhttp.send();
        }        
    </script>

    <script>
        function spawn_upload_button_sheet(){
            var course = $('#courseField').val();
            var session = $('#sessionField').val();
            var programme = document.getElementById('programmesField').value;
            //alert(session);
            const xhttp = new XMLHttpRequest();
            const xhttp2 = new XMLHttpRequest();

            xhttp.onload = function() {
              document.getElementById('sheet_btn').innerHTML = this.responseText;
              //ocument.getElementById('direct_btn').innerHTML = this.responseText;    
                     	
            }

            xhttp.open("GET","<?= base_url('gsp/upload_sheet_button/') ?>/"+programme+"/"+course+"/"+session+"/"+"\"",true);            
            xhttp.send();
            
        }        
    </script>

<script>
        function spawn_upload_button_direct(){
            var course = $('#courseField').val();
            var session = $('#sessionField').val();
            var programme = document.getElementById('programmesField').value;
            //alert(session);
            const xhttp = new XMLHttpRequest();
            const xhttp2 = new XMLHttpRequest();

            xhttp.onload = function() {
              //document.getElementById('sheet_btn').innerHTML = this.responseText;
              document.getElementById('direct_btn').innerHTML = this.responseText;    
                     	
            }

            xhttp.open("GET","<?= base_url('gsp/upload_direct_button/') ?>/"+programme+"/"+course+"/"+session+"/"+"\"",true);            
            xhttp.send();
            
        }        
    </script>

<script>
    function spawn_allocated_courses_upload(){
        var course = document.getElementById('sessionField').value;
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('allocatedCourseField').innerHTML = this.responseText
          document.getElementById('allocatedProgrammeField').innerHTML = "";
          document.getElementById('download_btn').innerHTML = "";
            }
      
           
        xhttp.open("GET","<?= base_url('gsp/get_allocated_courses_upload/') ?>/"+course+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_allocated_programmes_upload(){
        var course = document.getElementById('courseField').value;
        var session = $('#sessionField').val();
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);

          document.getElementById('allocatedProgrammeField').innerHTML = this.responseText;
          document.getElementById('download_btn').innerHTML = "";
            }
      

        xhttp.open("GET","<?= base_url('gsp/get_allocated_programme_upload/') ?>/"+course+"/"+session+"/"+"\"",true);
      	xhttp.send();
    }    
</script>


<script>
    function spawn_allocated_programmes_upload_(){
        var course = document.getElementById('courseField').value;
        const xhttp = new XMLHttpRequest();

        xhttp.onload = function() {
          //$('#ward_area').html(this.responseText);
          document.getElementById('allocatedProgrammeField').innerHTML = this.responseText;
            }
      

        xhttp.open("GET","<?= base_url('gsp/get_allocated_program_upload/') ?>/"+course+"/"+"\"",true);
      	xhttp.send();
    }    
</script>

<script>
    function spawn_results_uploaded(){
        //var programme = $('#progammes').val();
        var session = document.getElementById('sessionField').value; 
        //alert(session);
           	
                 if (window.XMLHttpRequest) {
                         // code for IE7+, Firefox, Chrome, Opera, Safari
                         xmlhttp = new XMLHttpRequest();
                     } else {
                         // code for IE6, IE5
                         xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");                
                     }
         
                 xmlhttp.onreadystatechange = function() {
                         
                         if (this.readyState == 4 && this.status == 200) {
                             
                            document.getElementById("txtHintDeptStudents").innerHTML = "";
                            document.getElementById("txtHintDeptStudents").innerHTML = this.responseText;
                                 
                         //stuff for data table     
                         $("#example1").DataTable({
                          "responsive": true, "lengthChange": false, "autoWidth": false, "searching": true,
                          "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
                        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                        $('#example2').DataTable({
                          "paging": true,
                          "lengthChange": false,
                          "searching": false,
                          "ordering": true,
                          "info": true,
                          "autoWidth": false,
                          "responsive": true,
                        }); 
                         $("#example11").DataTable({
                          "responsive": true, "lengthChange": false, "autoWidth": false, "searching": false,
                          "buttons": ["copy", "csv", "excel", "pdf", "print"]
                        }).buttons().container().appendTo('#example11_wrapper .col-md-6:eq(0)');
         
                         }else{
                             //alert(course);
                         }
                     };
         
                     xmlhttp.open("GET","<?= base_url('gsp/get_uploaded_results') ?>/"+session+"/"+"\"",true);
                     xmlhttp.send();
      }

    </script>


<script>
    const inputField = document.getElementById("ca_id");
    inputField.addEventListener("change", () => {
      alert("hello");
    });
</script>

<script>
    function exam_validation(x){

        //var ca_marks = document.getElementById(x+'_ca').value;
        var exam_marks = document.getElementById(x+'_exam').value;

        if(exam_marks == 'ABS' || exam_marks == 'I' || !isNaN(exam_marks)){
            document.getElementById(x+'_grade').value = exam_marks;
        }else{
          alert("Not allowed");
          document.getElementById(x+'_grade').value = "";
          document.getElementById(x+'_exam').value = "";
        }
        
        if(!isNaN(exam_marks)){

          if(exam_marks >= 0 && exam_marks <= 100){
            
            $total = Number(exam_marks);
            
            if($total >= 0 && $total <= 39){

              //document.getElementById(x+'_total').value = $total;
              document.getElementById(x+'_grade').value = 'F';

            }else if($total >= 40 && $total <= 44){

              //document.getElementById(x+'_total').value = $total;
              document.getElementById(x+'_grade').value = 'E';

            }else if($total >= 45 && $total <= 49){

              //document.getElementById(x+'_total').value = $total;
              document.getElementById(x+'_grade').value = 'D';
              
            }else if($total >= 50 && $total <= 59){

              //document.getElementById(x+'_total').value = $total;
              document.getElementById(x+'_grade').value = 'C';
              
            }else if($total >= 60 && $total <= 69){

              //document.getElementById(x+'_total').value = $total;
              document.getElementById(x+'_grade').value = 'B';
            
            }else if($total >= 70 && $total <= 100){

              //document.getElementById(x+'_total').value = $total;
              document.getElementById(x+'_grade').value = 'A';

            }
  
          }else{
            alert("Exam must be less than or equal to 100");
            document.getElementById(x+'_exam').value = "";
          document.getElementById(x+'_grade').value = "";
          }

        }/*else{
          alert("Not a number");
          document.getElementById(x+'_exam').value = "";
        }*/
    }    
</script>

<script> 
  $(document).ready(function(){
    $('#exampleModal').on('show.bs.modal', function(e){
      
      var result_id = $(e.relatedTarget).data('result_id');
      
      $('#hidden').val(result_id);
      //$('#decision').val(decision);
    });
 });
  
      
    $('#pwd_form').on('submit', function(event){
      event.preventDefault();
      var pass1 = $('#pass1').val();
      var pass2 = $('#pass2').val();
      
      if($('#pass1').val() != $('#pass2').val()){
        toastr.error("Password does not match");
      }else{
          $.ajax({
            url: "<?php echo base_url('gsp/password') ?>",
            method: "POST",
            data: $(this).serialize(),
            dataType: 'json',
            beforeSend:function(){
              $('#submit_button').attr('disabled', 'disabled');
              $('#submit_button').val('Please wait...');
            },
            success:function(data){
              $('#submit_button').attr('disabled', false);
              if(data.error != ''){
                toastr.error(data.error);
                $('#submit_button').val('Submit');
              }else{
                toastr.success(data.success);
                $('#pass1').val('');
                $('#pass2').val('');
                $('#submit_button').val('Submit');
              }
            }
          })
      }
    });
    
    
    $('#xlsFileToUpload').change(function () {
        var file = $(this)[0].files[0];
        if (typeof ($("#xlsFileToUpload")[0].files) != "undefined") {
            if (file.type!='application/vnd.ms-excel') {
                $("#xlsFileToUpload").val('');
                toastr.error('Please select a excel file');
            }
        } else {
            toastr.error('This browser does not support HTML5.');
        }
    });
    </script>

</body>
</html>
