<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Yusuf Maitama Sule University Kano</title>

	<!-- Google Font: Source Sans Pro -->
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link rel="shortcut icon" href="<?= base_url("/../assets_/img/yumsuk_logo.png");?>" type="image/x-icon">
	<!-- Font Awesome -->
	<link rel="stylesheet" href="<?= base_url('/../assets_/plugins/fontawesome-free/css/all.min.css') ?>">
	<!-- Uncheck bootstrap -->
	<link rel="stylesheet" href="<?= base_url('/../assets_/plugins/icheck-bootstrap/icheck-bootstrap.min.css') ?>">
  <!-- Toastr -->
  <link rel="stylesheet" href="<?= base_url('/../assets_/plugins/toastr/toastr.min.css') ?>">
	<!-- Theme style -->
	<link rel="stylesheet" href="<?= base_url('/../assets_/dist/css/adminlte.min.css') ?>">
	<style media="screen">
		#timer {
		    font-size: 1.2em;
		    font-weight: 700;
		    color: black;
		    padding: 5px;
		}

		#timer div {
		    display: inline-block;
		    min-width: 50px;
		    padding: 5px;
		    margin: 5px 0px 5px 5px;
		}

		#timer div span {
		    color: black;
		    display: block;
		    margin-top: 5px;
		    font-size: .5em;
		    font-weight: 400;
		}
  </style>
</head>
<body class="hold-transition login-page">
<div class="login-box">
  <div class="login-logo">
    <img src="<?= base_url('../assets_/img/yumsuk_logo.png') ?>" style="width: 100px;" alt="Kano_Logo"><br/>
        <h6>Yusuf Maitama Sule University, Kano</h6>
        <h5><b class="badge badge-primary">YUMSUK Result Processing System</b></h5>
  </div>
  <!-- /.login-logo -->
  <div class="card">
    <div class="card-body login-card-body">
      <p class="login-box-msg">Sign in to start your session</p>

      <?php $page_session = \Config\Services::session(); ?>
                  <?php

                  if($page_session->getTempdata('loginError')):       
                  ?>
                  <div class = "alert alert-danger">
                       <?= $page_session->getTempdata('loginError'); ?>
                  </div>
                  <?php 
                  endif;
                  ?>

      <?php $page_session = \Config\Services::session(); ?>
          <?php
          if($page_session->getTempdata('passwordChanged')):       
                  ?>
                  <div class = "alert alert-success">
                       <?= $page_session->getTempdata('passwordChanged'); ?>
                  </div>
                  <?php 
                  endif;
                  ?>
      
      <form action="<?= base_url('hod/login_checker') ?>" method="post">
        <div class="mb-3">
          <select class="form-control" required>
            <option selected disabled value="">- Select account type -</option>
            <option disabled>Vice-Chancellor</option>
            <option disabled>SBC</option>
            <option disabled>Dean</option>
            <option>Head of Department</option>
            <option>GSP Coordinator</option>
            <option>Examinations Officer</option>
            <option>Level Coordinator</option>
            <option>Lecturer</option>
          </select>
        </div>
        <div class="input-group mb-3">
          <input type="text" name="email" class="form-control" placeholder="Email" value="<?=set_value('email')?>" required>
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-envelope"></span>
            </div>
          </div>
        </div>
        <div class="input-group mb-3">
          <input type="password" name="password" class="form-control" placeholder="Password" required>
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
        </div>
        <div class="row">

          <!-- /.col -->
          <div class="col-12">
            <button type="submit" class="btn btn-primary btn-block">Sign In</button>
          </div>
          <!-- /.col -->
        </div>
      </form>
      <hr/>
        <div class="text-center">        
        <h5 id="up"><span class="badge badge-secondary">Result input/upload Countdown</span></h5>
          <div id="timer"></div>
        <h6 id="down"><small>Please make sure you upload and make all necessary corrections before the deadline</small></h6>
        </div>
    </div>
    <!-- /.login-card-body -->
  </div>
</div>
<!-- /.login-box -->

<!-- jQuery -->
<script src="<?= base_url('assets_/plugins/jquery/jquery.min.js') ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?= base_url('assets_/plugins/bootstrap/js/bootstrap.bundle.min.js') ?>"></script>
<!-- Toastr -->
<script src="<?= base_url('assets_/plugins/toastr/toastr.min.js') ?>"></script>
<script >
	<?php 
           //$data = strtotime($date);
           //$getDate = date("F d, Y", $data);
           $getDate = "mar 31, 2023";
           $time = "23:59:59";
        ?>
        var countDownDate = new Date("<?php echo "$getDate $time"; ?>").getTime();
        // Update the count down every 1 second
        var x = setInterval(function() {
            var now = new Date().getTime();
            // Find the distance between now an the count down date
            var distance = countDownDate - now;
            // Time calculations for days, hours, minutes and seconds
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            // Output the result in an element with id="counter"11
            /*document.getElementById("counter").innerHTML = days + " Day(s)  " + hours + "h " +
            minutes + "m " + seconds + "s ";*/
            document.getElementById("timer").innerHTML = '<div>' + days + '<span>Days</span></div>' +
  '<div>' + hours + '<span>Hours</span></div>' +
  '<div>' + minutes + '<span>Minutes</span></div>' +
  '<div>' + seconds + '<span>Seconds</span></div>';
            // If the count down is over, write some text 
            if (distance < 0) {
                $('#up').hide();
                $('#down').hide();
                clearInterval(x);
                document.getElementById("timer").innerHTML = "<small class='badge badge-danger'>Result upload disabled</small>";
            }
        }, 1000);</script>
<!-- AdminLTE App -->
<script src="<?= base_url('assets_/dist/js/adminlte.min.js') ?>"></script>
</body>
</html>
